-- Ask file path if no file was dragged
try
	set tmp to filePath
on error
	set filePath to choose file with prompt "Please select an image file."
end try


-- Get Original Size
tell application "Image Events"
	set anImage to open filePath
	copy dimensions of anImage to {w, h}
end tell


-- Ask new Scale
repeat
	try
		display dialog "Enter the desired scale percent to resize the image:" default answer 100
		set newScale to the text returned of the result as integer
		if newScale is greater than 0 then
			set the newScale to (newScale * 0.01)
			exit repeat
		end if
	on error number error_number
		if the error_number is -128 then
			return "user cancelled"
		end if
	end try
end repeat


-- Resize
tell application "Image Events"
	scale anImage by factor newScale
	save anImage in filePath
	close anImage
end tell